"""Tableware."""
from mojo import Mojo

from bigym.const import ASSETS_PATH
from bigym.envs.props.prop import Prop

PLATE_MODEL_PATH = ASSETS_PATH / "props/plate/plate.xml"


class Plate(Prop):
    """Plate."""

    def __init__(self, mojo: Mojo, kinematic: bool = True):
        """Init."""
        super().__init__(mojo, PLATE_MODEL_PATH, kinematic, True)


MUG_MODEL_PATH = ASSETS_PATH / "props/mug/mug.xml"


class Mug(Prop):
    """Mug."""

    def __init__(self, mojo: Mojo, kinematic: bool = True):
        """Init."""
        super().__init__(mojo, MUG_MODEL_PATH, kinematic, True)


PAN_MODEL_PATH = ASSETS_PATH / "props/pan/pan.xml"


class Pan(Prop):
    """Pan."""

    def __init__(self, mojo: Mojo, kinematic: bool = True):
        """Init."""
        super().__init__(mojo, PAN_MODEL_PATH, kinematic, True)


SAUCEPAN_MODEL_PATH = ASSETS_PATH / "props/saucepan/saucepan.xml"


class Saucepan(Prop):
    """Saucepan."""

    def __init__(self, mojo: Mojo, kinematic: bool = True):
        """Init."""
        super().__init__(mojo, SAUCEPAN_MODEL_PATH, kinematic, True)


CHOPPING_BOARD_MODEL_PATH = ASSETS_PATH / "props/board/board.xml"


class ChoppingBoard(Prop):
    """Chopping Board."""

    def __init__(self, mojo: Mojo, kinematic: bool = True):
        """Init."""
        super().__init__(mojo, CHOPPING_BOARD_MODEL_PATH, kinematic, True)
